// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef EMUTIME_H
#define EMUTIME_H

#include "degub.h"
#include "ini.h"

union ULI { //Unsigned Large Integer
	QWORD QuadPart;
	struct {
		DWORD LowPart;
		DWORD HighPart;
	};

	ULI() {}
	ULI(QWORD q) : QuadPart(q) {}
	operator const QWORD &() const { return QuadPart; }
	operator QWORD &() { return QuadPart; }

	bool isAfter(const ULI &other) const {
		return !((QuadPart - other.QuadPart) & (QWORD(1)<<63)); }
};

inline void GET_RTC(ULI *uli) {
	GLE(QueryPerformanceCounter((LARGE_INTEGER *)uli));
}

QWORD TB_2_RTC(DWORD tb);  //(tb*RTCF)/TB_PER_S
//QWORD RTC_2_TB(QWORD rtc); //(rtc*TB_PER_S)/RTCF //unused
DWORD RTC_2_TBU(QWORD rtc);
DWORD RTC_2_TBL(QWORD rtc);

QWORD TB_2_CYCLES(DWORD tb);	//tb*(BOGOMIPS/TB_PER_S)
//QWORD CYCLES_2_TB(QWORD cycles); //cycles/(BOGOMIPS/TB_PER_S)  //unused
DWORD CYCLES_2_TBU(QWORD cycles);
DWORD CYCLES_2_TBL(QWORD cycles);

DWORD RTC_2_MS(QWORD rtc); //(rtc*1000)/RTCF

class CycleCounterBase {
public:
	CycleCounterBase();
	const ULI &cycles;
protected:
	ULI cpp, ct, ccp; //previous period, total, current period
private:
	CycleCounterBase& operator=(const CycleCounterBase&);
};

#define CPU_CORE_HZ 486000000
#define CPU_BUS_HZ 162000000
#define TB_PER_MS 40500  //40.5 MHz (162 / 4)
#define TB_PER_S 40500000
//#define BOGOMIPS 890181858
#define BOGOMIPS 891000000  //to conform to TB frequency for faster math

#define ADDITIVE_TIMING(variable)
//#define ADDITIVE_TIMING(variable) AdditiveTiming timing(variable)

inline QWORD do_rdtsc() {
	__asm rdtsc;
}

class AdditiveTiming {	//unstable timing, only suitable for percentages
public:
	AdditiveTiming(ULI *target) : t(target) {
		//if(!g::dual_run) {
		start = do_rdtsc();
		//}
	}
	~AdditiveTiming() {
		//if(!g::dual_run) {
		ULI stop = do_rdtsc();
		*t += (stop - start);
		//}
	}
private:
	ULI *t;
	ULI start;
};

class Timing {	//hr snakkar vi timing ;)
public:
	Timing(const char *title) : t(title) {
		if(g::degub_msg) {
			DEGUB("%s started\n", title);
		}
		GET_RTC(&start);
	}
	~Timing() {
		ULI uli;
		GET_RTC(&uli);
		uli -= start;
		DEGUB("%s took %f ms (%I64i ticks)\n", t,
			(float(uli) * 1000) / float(g::rtcf), uli.QuadPart);
	}
private:
	const char *t;
	ULI start;
};

#define DELTA_TIMING \
{\
	static ULI then;\
	ULI now;\
	GET_RTC(&now);\
	DEGUB(" delta: %I64i ms (%I64i ticks)\n",\
	((now - then) * 1000) / g::rtcf, now - then);\
	then = now;\
}

#endif	//EMUTIME_H
